/*
 * Decompiled with CFR 0.152.
 */
package tiled.io;

import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import tiled.core.Map;
import tiled.core.TileSet;
import tiled.io.MapReader;
import tiled.io.MapWriter;
import tiled.io.PluggableMapIO;
import tiled.io.PluginLogger;
import tiled.io.xml.XMLMapTransformer;
import tiled.io.xml.XMLMapWriter;
import tiled.mapeditor.Resources;
import tiled.mapeditor.dialogs.PluginLogDialog;
import tiled.mapeditor.plugin.PluginClassLoader;
import tiled.util.TiledConfiguration;

public class MapHelper {
    private static PluginClassLoader pluginLoader;
    public static final String ERROR_LOAD_MAP;
    public static final String ERROR_LOAD_TILESET;

    public static void init(PluginClassLoader p) {
        pluginLoader = p;
    }

    public static void saveMap(Map currentMap, String filename) throws Exception {
        MapWriter mw = filename.endsWith(".tmx") || filename.endsWith(".tmx.gz") ? new XMLMapWriter() : (MapWriter)pluginLoader.getWriterFor(filename);
        if (mw == null) {
            throw new Exception("Unsupported map format");
        }
        PluginLogger logger = new PluginLogger();
        mw.setLogger(logger);
        mw.writeMap(currentMap, filename);
        currentMap.setFilename(filename);
        MapHelper.reportPluginMessages(logger);
    }

    public static void saveTileset(TileSet set, String filename) throws Exception {
        MapWriter mw = filename.endsWith(".tsx") ? new XMLMapWriter() : (MapWriter)pluginLoader.getWriterFor(filename);
        if (mw == null) {
            throw new Exception("Unsupported tileset format");
        }
        PluginLogger logger = new PluginLogger();
        mw.setLogger(logger);
        mw.writeTileset(set, filename);
        set.setSource(filename);
        MapHelper.reportPluginMessages(logger);
    }

    public static void saveMap(Map currentMap, PluggableMapIO pmio, String filename) throws Exception {
        MapWriter mw = (MapWriter)pmio;
        PluginLogger logger = new PluginLogger();
        mw.setLogger(logger);
        mw.writeMap(currentMap, filename);
        currentMap.setFilename(filename);
        MapHelper.reportPluginMessages(logger);
    }

    public static Map loadMap(String file) throws Exception {
        Map ret = null;
        try {
            MapReader mr = file.endsWith(".tmx") || file.endsWith(".tmx.gz") ? new XMLMapTransformer() : (MapReader)pluginLoader.getReaderFor(file);
            if (mr == null) {
                throw new Exception("Unsupported map format");
            }
            PluginLogger logger = new PluginLogger();
            mr.setLogger(logger);
            ret = mr.readMap(file);
            ret.setFilename(file);
            MapHelper.reportPluginMessages(logger);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage() + (e.getCause() != null ? "\nCause: " + e.getCause().getMessage() : ""), ERROR_LOAD_MAP, 0);
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while loading " + file + ": " + e.getMessage() + (e.getCause() != null ? "\nCause: " + e.getCause().getMessage() : ""), ERROR_LOAD_MAP, 0);
            e.printStackTrace();
        }
        return ret;
    }

    public static TileSet loadTileset(String file) throws Exception {
        TileSet ret = null;
        try {
            MapReader mr = file.endsWith(".tsx") ? new XMLMapTransformer() : (MapReader)pluginLoader.getReaderFor(file);
            if (mr == null) {
                throw new Exception("Unsupported tileset format");
            }
            PluginLogger logger = new PluginLogger();
            mr.setLogger(logger);
            ret = mr.readTileset(file);
            ret.setSource(file);
            MapHelper.reportPluginMessages(logger);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getMessage() + (e.getCause() != null ? "\nCause: " + e.getCause().getMessage() : ""), ERROR_LOAD_TILESET, 0);
            e.printStackTrace();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error while loading " + file + ": " + e.getMessage() + (e.getCause() != null ? "\nCause: " + e.getCause().getMessage() : ""), ERROR_LOAD_TILESET, 0);
            e.printStackTrace();
        }
        return ret;
    }

    private static void reportPluginMessages(PluginLogger logger) {
        Preferences prefs = TiledConfiguration.node("io");
        if (prefs.getBoolean("reportWarnings", false)) {
            PluginLogDialog pluginLogDialog = new PluginLogDialog();
        }
    }

    static {
        ERROR_LOAD_MAP = Resources.getString("general.file.noload.map");
        ERROR_LOAD_TILESET = Resources.getString("general.file.noload.tileset");
    }
}

